package gov.va.med.domain.service.messaging;

import java.io.Serializable;

/**
 * Encapsulates useful data about the message for use in sending it.  
 * 
 * FUTURE cosider retiring this.  It adds little value but is heavily referenced.  
 * the synchronous or asynchronous is really determined more by the parameters,
 * the transciver that is used,  and the encoder/decoder.   
 * If a JMS transceiver is used  for example,  it is asynchrounous regardless of 
 * the MessageExchangePatternType.  Also, asynchrounous can actually be 
 * physically synchronous (possibly because a commit ack is received) 
 * but treated as asynch because the real response comes later.  
 * 
 * @author Odysseas Pentakalos
 * @version $Id: MessageExchangePatternType.java,v 1.6 2005/08/27 19:19:20 alex.kalinovsky Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
public class MessageExchangePatternType implements Serializable
{
    private static final long serialVersionUID = 3617859668165144886L;
    private final static int SYNCHRONOUS_MESSAGE_EXCHANGE_PATTERN_CODE = 0;
	private final static int ASYNCHRONOUS_MESSAGE_EXCHANGE_PATTERN_CODE = 1;

	private int mepType;
	
	public static MessageExchangePatternType SYNCHRONOUS_MESSAGE_EXCHANGE_PATTERN = new 
		MessageExchangePatternType(SYNCHRONOUS_MESSAGE_EXCHANGE_PATTERN_CODE);
	public static MessageExchangePatternType ASYNCHRONOUS_MESSAGE_EXCHANGE_PATTERN = new 
		MessageExchangePatternType(ASYNCHRONOUS_MESSAGE_EXCHANGE_PATTERN_CODE);
	
	private MessageExchangePatternType(int mepType) {
		this.mepType = mepType;
	}
   
   public String toString() {
      if (mepType == SYNCHRONOUS_MESSAGE_EXCHANGE_PATTERN_CODE)
         return "SYNCHRONOUS_MESSAGE_EXCHANGE_PATTERN_CODE";
      if (mepType == ASYNCHRONOUS_MESSAGE_EXCHANGE_PATTERN_CODE)
         return "ASYNCHRONOUS_MESSAGE_EXCHANGE_PATTERN_CODE";
      return "Undefined";
   }
}
